<?php
session_start();
if (!isset($_SESSION['logado']) || $_SESSION['logado'] !== true) {
    header("Location: login.php");
    exit();
}

$arquivo = 'dados/links.json';
if (!file_exists('dados')) mkdir('dados');
if (!file_exists($arquivo)) file_put_contents($arquivo, json_encode([]));

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nome = trim($_POST['nome'] ?? '');
    $url = trim($_POST['url'] ?? '');
    $imagem = trim($_POST['imagem'] ?? '');

    if ($nome && $url && $imagem) {
        $links = json_decode(file_get_contents($arquivo), true);
        $links[] = ['nome' => $nome, 'url' => $url, 'imagem' => $imagem];
        file_put_contents($arquivo, json_encode($links, JSON_PRETTY_PRINT));
        header("Location: painel.php");
        exit();
    }
}

$links = json_decode(file_get_contents($arquivo), true);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Painel de Gerenciamento</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <style>
        body {
            background: linear-gradient(135deg, #340163, #460163);
            color: #fff;
        }
        .container {
            max-width: 800px;
            margin: 40px auto;
        }
        .form-control, .btn {
            border-radius: 10px;
        }
        .list-group-item {
            background-color: rgba(255, 255, 255, 0.1);
            border: none;
            border-radius: 10px;
            margin-bottom: 10px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            padding: 15px;
        }
        .list-group-item img {
            width: 50px;
            height: 50px;
            object-fit: contain;
            border-radius: 6px;
        }
        @media (max-width: 576px) {
            .list-group-item {
                flex-direction: column;
                align-items: flex-start;
            }
            .list-group-item a {
                margin-top: 10px;
                width: 100%;
                text-align: center;
            }
        }
    </style>
</head>
<body>
<div class="container py-4">
    <h2 class="text-center mb-4">Gerenciador de Links</h2>

    <form method="POST" class="row g-3 mb-4">
        <div class="col-md-4 col-12">
            <input type="text" name="nome" class="form-control" placeholder="Nome" required>
        </div>
        <div class="col-md-4 col-12">
            <input type="text" name="url" class="form-control" placeholder="URL (sem https://)" required>
        </div>
        <div class="col-md-4 col-12">
            <input type="text" name="imagem" class="form-control" placeholder="Imagem (ex: logo.png)" required>
        </div>
        <div class="col-12 text-center">
            <button type="submit" class="btn btn-success px-5">Adicionar Link</button>
        </div>
    </form>

    <ul class="list-group">
        <?php foreach ($links as $link): ?>
            <li class="list-group-item">
                <div class="d-flex align-items-center gap-3">
                    <img src="imagens/<?= htmlspecialchars($link['imagem']) ?>" alt="Logo">
                    <strong><?= htmlspecialchars($link['nome']) ?></strong>
                </div>
                <a href="https://<?= htmlspecialchars($link['url']) ?>" class="btn btn-outline-light btn-sm mt-2 mt-sm-0" target="_blank">Visitar</a>
            </li>
        <?php endforeach; ?>
    </ul>
</div>
</body>
</html>
